@echo off
title RustDesk

:: Переходим на рабочий стол пользователя
cd /d %userprofile%\Desktop

echo.
echo.
echo    RustDesk
echo.
echo.

:: Удаляем настройки RustDesk (очистка)
if exist %AppData%\RustDesk (rmdir /s /q %AppData%\RustDesk)

echo.
echo.
echo    Creating configuration file
echo.
echo.

:: Проверяем и создаем конфигурационные папки, если их нет
if not exist %appdata%\RustDesk md %appdata%\RustDesk
if not exist %appdata%\RustDesk\config md %appdata%\RustDesk\config

:: Создаем конфигурационный файл RustDesk2.toml
(
  echo rendezvous_server = "rda.centrum-group.uz:21116"
  echo nat_type = 2
  echo serial = 0
  echo.
  echo [options]
  echo key = "4rMfG5XfmmyjfCElMsrTqko3+tztTRDC3Gqb+ZedSOI="
  echo custom-rendezvous-server = "rda.centrum-group.uz"
) > %appdata%\RustDesk\config\RustDesk2.toml

:: Получение версии с веб-страницы
for /f "tokens=2 delims=: " %%i in ('curl -s https://rd.centrum-group.uz/ ^| findstr "version"') do set "version=%%i"

:: Формирование имени файла
set "filename=rustdesk-%version%-x86_64.exe"

echo Final Filename: %filename%

echo.
echo Searching for files starting with rustdesk- in the current directory...
echo.

:: Удаляем старые файлы, если они отличаются от текущей версии
for %%f in (rustdesk-*) do (
    if "%%f" neq "%filename%" (
        echo Deleting file: %%f
        del /f /q "%%f"
    ) else (
        echo Keeping file: %%f
    )
)

echo.
echo Operation completed.
echo.

:: Формируем URL для скачивания
set "download_url=https://github.com/rustdesk/rustdesk/releases/download/%version%/%filename%"

echo Download URL: %download_url%

:: Скачиваем RustDesk, если файл еще не существует
if not exist %filename% (
  echo    RustDesk downloading software, please wait...
  powershell -Command "(New-Object Net.WebClient).DownloadFile('%download_url%', '%filename%')" > nul 2>&1
  if %errorlevel% neq 0 (
      echo Error: Failed to download RustDesk.
      exit /b 1
  )
)

echo.
echo.
echo   !!! INSTALLATION COMPLETED !!!
echo.
echo.

:: Запускаем скачанный файл
start %filename% > nul
echo.
echo.
exit
